<?php
/**
 * Update Link Category
 *
 * @package     AutomatorWP\Integrations\ShortLinksPro\Actions\Update_Link_Category
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_ShortLinksPro_Update_Link_Category extends AutomatorWP_Integration_Action {

    public $integration = 'shortlinkspro';
    public $action = 'shortlinkspro_update_link_category';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Update the category of the link', 'automatorwp-pro' ),
            'select_option'     => __( 'Update the <strong>category</strong> of the link', 'automatorwp-pro' ),
            /* translators: %1$s: Link title. %2$s: Category title */
            'edit_label'        => sprintf( __( 'Update %1$s link with %2$s category', 'automatorwp-pro' ), '{link}', '{category}' ),
            /* translators: %1$s: Link title. %2$s: Category title */
            'log_label'         => sprintf( __( 'Update %1$s link with %2$s category', 'automatorwp-pro' ), '{link}', '{category}' ),
            'options'           => array(
                'link' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'link',
                    'name'              => __( 'Link:', 'automatorwp-pro' ),
                    'option_default'    => __( 'Select a link', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_shortlinkspro_get_links',
                    'options_cb'        => 'automatorwp_shortlinkspro_options_cb_link',
                    'default'           => ''
                ) ),
                'category' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'category',
                    'name'              => __( 'Category:', 'automatorwp-pro' ),
                    'option_default'    => __( 'Select a category', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_shortlinkspro_get_categories',
                    'options_cb'        => 'automatorwp_shortlinkspro_options_cb_category',
                    'default'           => ''
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {
    
        $this->result = '';

        // Shorthand
        $link_id = $action_options['link'];
        $category_id = $action_options['category']; 
        $table = 'shortlinkspro_link_categories';

        // Bail if no target URL
        if ( empty( $link_id ) ) {
            $this->result = __('No link selected.', 'automatorwp-pro');
            return;
        }

        // Bail if no category
        if ( empty( $category_id ) ) {
            $this->result = __('No category selected.', 'automatorwp-pro');
            return;
        }

        shortlinkspro_handle_terms_save( $link_id, $category_id, $table );

        $this->result = __('Link category updated.', 'automatorwp-pro');
    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        // Log meta data
        add_filter( 'automatorwp_user_completed_action_log_meta', array( $this, 'log_meta' ), 10, 5 );

        // Log fields
        add_filter( 'automatorwp_log_fields', array( $this, 'log_fields' ), 10, 5 );

        parent::hooks();

    }

    /**
     * Action custom log meta
     *
     * @since 1.0.0
     *
     * @param array     $log_meta           Log meta data
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     *
     * @return array
     */
    public function log_meta( $log_meta, $action, $user_id, $action_options, $automation ) {

        // Bail if action type don't match this action
        if( $action->type !== $this->action ) {
            return $log_meta;
        }

        // Store the action's result
        $log_meta['result'] = $this->result;

        return $log_meta;
    }

    /**
     * Action custom log fields
     *
     * @since 1.0.0
     *
     * @param array     $log_fields The log fields
     * @param stdClass  $log        The log object
     * @param stdClass  $object     The trigger/action/automation object attached to the log
     *
     * @return array
     */
    public function log_fields( $log_fields, $log, $object ) {

        // Bail if log is not assigned to an action
        if( $log->type !== 'action' ) {
            return $log_fields;
        }

        // Bail if action type don't match this action
        if( $object->type !== $this->action ) {
            return $log_fields;
        }

        $log_fields['result'] = array(
            'name' => __( 'Result:', 'automatorwp-pro' ),
            'type' => 'text',
        );

        return $log_fields;
    }

}

new AutomatorWP_ShortLinksPro_Update_Link_Category();